/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipeBuilder
extends AbstractRecipeBuilder<PartRecipeBuilder> {
    private final IMaterialItem output;
    private final int outputAmount;
    private int cost = 1;
    private class_2960 pattern = null;
    private class_1856 patternItem;

    public static PartRecipeBuilder partRecipe(IMaterialItem output) {
        return PartRecipeBuilder.partRecipe(output, 1);
    }

    @Override
    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, class_7923.field_41178.method_10221((Object)this.output.method_8389()));
    }

    @Override
    public void save(Consumer<class_2444> consumerIn, class_2960 id) {
        if (this.outputAmount <= 0) {
            throw new IllegalStateException("recipe " + id + " must output at least 1");
        }
        if (this.cost <= 0) {
            throw new IllegalStateException("recipe " + id + " has no cost associated with it");
        }
        if (this.pattern == null) {
            throw new IllegalStateException("recipe " + id + " has no pattern associated with it");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "parts");
        consumerIn.accept(new Result(id, advancementId));
    }

    private PartRecipeBuilder(IMaterialItem output, int outputAmount) {
        this.output = output;
        this.outputAmount = outputAmount;
    }

    public static PartRecipeBuilder partRecipe(IMaterialItem output, int outputAmount) {
        return new PartRecipeBuilder(output, outputAmount);
    }

    public PartRecipeBuilder setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public PartRecipeBuilder setPattern(class_2960 pattern) {
        this.pattern = pattern;
        return this;
    }

    public PartRecipeBuilder setPatternItem(class_1856 patternItem) {
        this.patternItem = patternItem;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super(ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            if (!PartRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", PartRecipeBuilder.this.group);
            }
            json.addProperty("pattern", PartRecipeBuilder.this.pattern.toString());
            if (PartRecipeBuilder.this.patternItem != null) {
                json.add("pattern_item", PartRecipeBuilder.this.patternItem.method_8089());
            }
            json.addProperty("cost", (Number)PartRecipeBuilder.this.cost);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", class_7923.field_41178.method_10221((Object)PartRecipeBuilder.this.output.method_8389()).toString());
            if (PartRecipeBuilder.this.outputAmount > 1) {
                jsonOutput.addProperty("count", (Number)PartRecipeBuilder.this.outputAmount);
            }
            json.add("result", (JsonElement)jsonOutput);
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerTables.partRecipeSerializer.get();
        }
    }
}

